#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import configreader
import os
import os.path
import re
import random

import recdblist
def ts2x264(pin, pout, opts):#sizeは"HD"か"SD"
    """
    pinで指定されたファイルをpoutにx264でエンコードして書き出す
    """
    dualpass = 0
    is24fps=0
    size="HD"
    crf=18
    quality=4
    quality=int(configreader.getenv("x264_preset"))
    crf=int(configreader.getenv("crf"))
    if re.search("H", opts):
        size = "HD"
    if re.search("S", opts):
        size = "WVGA"
    if re.search("F", opts):
        size = "FullHD"
    if re.search("W",opts):
        size = "WVGA"
    if re.search("MW8", opts):
        size = "QVGA_BASE"
        crf=crf+4
    if re.search("MW9", opts):
        size = "WVGA_BASE"
        crf=crf+2
    if re.search("v", opts):
        is24fps=1
        crf=int(configreader.getenv("animation_crf"))
    if re.search("a", opts):
        is24fps=1
        crf=int(configreader.getenv("animation_crf"))
    if re.search("q",opts):
        quality=quality-2
    if re.search("w",opts):
        quality=quality-1
    if re.search("e",opts):
        quality=quality+1
    if re.search("r",opts):
        quality=quality+2
    if re.search("u",opts):
        crf=crf+2
    if re.search("i",opts):
        crf=crf+1
    if re.search("o",opts):
        crf=crf-1
    if re.search("p",opts):
        crf=crf-2
    if re.search("d",opts):
        #encode_ffmpeg_kai(pin,pout,size,is24fps,quality,crf)
        encode_ffmpeg_sar(pin,pout,size,is24fps,quality,crf)
    elif re.search("5",opts):
        #encode_ffmpeg_kai(pin,pout,size,is24fps,quality,crf)
        encode_ffmpeg_sar(pin,pout,size,is24fps,quality,crf)
    elif re.search("Y",opts):
        encode_sar(pin,pout,size,is24fps,quality,crf)
    elif re.search("Z",opts):
        encode_ffmpeg_sar(pin,pout,size,is24fps,quality,crf)
    elif re.search("b",opts):
        try:
            tm2v=pin.replace(".ts",".m2v")
            #encode(tm2v, pout,size,is24fps,quality,crf)
            encode_sar(tm2v, pout,size,is24fps,quality,crf)
        except Exception, inst:
            recdblist.Commonlogex("Error", "ts2x264(ts2x264.py)", str(type(inst)), str(inst))
    else:
        try:
            #encode(pin, pout,size,is24fps,quality,crf)
            encode_sar(pin, pout,size,is24fps,quality,crf)
        except Exception, inst:
            recdblist.Commonlogex("Error", "ts2x264(ts2x264.py)", str(type(inst)), str(inst))
def encode(pin,pout,size,is24fps,quality,crf):
    mencoder=configreader.getpath("mencoder")
    x264=configreader.getpath("x264")
    encvf=""
    txt=""
    encvf="-vf yadif=0,pp=l5"
    harddup=",hqdn3d=2:1:2,unsharp=l3x3:0.75:c3x3:0.75,harddup"
    ofps="-ofps 30000/1001"
    fps="-fps 30000/1001"
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="5000"
    x264_thread="auto"
    try:
        xtt=configreader.getenv("x264_thread")
        xtt=int(xtt)
        if xtt>0:
            x264_thread=str(xtt)
    except:
        x264_thread="auto"
    x264_addline=configreader.getenv("x264_addline")
    if is24fps==1:
        ofps="-ofps 24000/1001"
        fps="-fps 30000/1001"
        x264fps="--fps 24000/1001"
        x264tune="--tune animation"
        encvf="-vf pullup,softskip"
        harddup=",pp=l5,unsharp=l3x3:0.75:c3x3:0.75,hqdn3d=2:1:2,harddup"
    if size == "HD":
        encvf = encvf + ",scale=-2:720::0:3,expand=1280:720"+harddup
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        encvf = encvf + ",scale=-2:480::0:3,expand=854:480"+harddup
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        encvf = encvf + ",scale=-2:1080::0:3,expand=1920:1080"+harddup
        x264streamsize=u"1920x1080"
        x264_bitrate="5000"
    elif size == "SD":
        encvf = encvf + ",scale=720:-2::0:3,expand=720:480"+harddup
        x264streamsize=u"720x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        encvf = encvf + ",scale=320:-2::0:3,expand=320:240"+harddup
        x264streamsize=u"320x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        encvf = encvf + ",scale=-2:480::0:3,expand=854:480"+harddup
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    else:
        encvf = encvf + ",scale=-2:720::0:3,expand=1280:720"+harddup
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    os.environ['LANG']="ja_JP.UTF-8"
    random.seed(pin)
    random.jumpahead(10)
    streampath=os.path.join(os.path.dirname(pin),str(random.randint(10000, 999999)))
    os.system(u"mkfifo "+streampath)
    encexe=mencoder+u" \""+pin+u"\" -vfm ffmpeg -quiet -sws 9 "+encvf+u",format=i420 "+fps+" "+ofps+" -oac mp3lame -ovc raw -of rawvideo -o \""+streampath+"\" &"
    encexe=encexe+u" nice -n 19 "+x264+" "+x264crf+u" "+x264_addline+u"  --threads "+x264_thread+" "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" "+streampath+" "+x264streamsize
    encexe=u"nice -n 19 " +encexe
    recdblist.printutf8(encexe)
    txt=""
    try:
        txt=unicode(commands.getoutput(encexe.encode('utf-8')),'utf-8')
    except:
        ""
    os.system("rm "+streampath)
    recdblist.addCommandLog(pin, u"Mencoder", encexe, txt)
def encode_sar(pin,pout,size,is24fps,quality,crf):
    mencoder=configreader.getpath("mencoder")
    x264=configreader.getpath("x264")
    encvf=""
    txt=""
    encvf="-vf yadif=0,pp=l5"
    harddup=",hqdn3d=2:1:2,unsharp=l3x3:0.75:c3x3:0.75,harddup"
    ofps="-ofps 30000/1001"
    fps="-fps 30000/1001"
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="5000"
    x264_thread="auto"
    tsar=getMoviePAR(pin)
    x264_sar="--sar "+str(tsar[0])+":"+str(tsar[1])
    try:
        xtt=configreader.getenv("x264_thread")
        xtt=int(xtt)
        if xtt>0:
            x264_thread=str(xtt)
    except:
        x264_thread="auto"
    x264_addline=configreader.getenv("x264_addline")
    if is24fps==1:
        ofps="-ofps 24000/1001"
        fps="-fps 30000/1001"
        x264fps="--fps 24000/1001"
        x264tune="--tune animation"
        encvf="-vf pullup,softskip"
        harddup=",pp=l5,unsharp=l3x3:0.75:c3x3:0.75,hqdn3d=2:1:2,harddup"
    if size == "HD":
        tsize=get_par_size(pin,720)
        encvf = encvf + ",scale=-3:720::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        tsize=get_par_size(pin,480)
        encvf = encvf + ",scale=-3:480::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        tsize=get_par_size(pin,1080)
        encvf = encvf + ",scale=-3:1080::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x1080"
        x264_bitrate="5000"
    elif size == "QVGA_BASE":
        tsize=get_par_size(pin,240)
        encvf = encvf + ",scale=-3:240::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        tsize=get_par_size(pin,480)
        encvf = encvf + ",scale=-3:480::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x480"
        x264_bitrate="1500"
    else:
        tsize=get_par_size(pin,720)
        encvf = encvf + ",scale=-3:720::0:3"+harddup
        x264streamsize=str(tsize[0])+u"x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    os.environ['LANG']="ja_JP.UTF-8"
    random.seed(pin)
    random.jumpahead(10)
    streampath=os.path.join(os.path.dirname(pin),str(random.randint(10000, 999999)))
    os.system(u"mkfifo "+streampath)
    encexe=mencoder+u" \""+pin+u"\" -vfm ffmpeg -quiet -sws 9 "+encvf+u",format=i420 "+fps+" "+ofps+" -oac mp3lame -ovc raw -of rawvideo -o \""+streampath+"\" &"
    encexe=encexe+u" nice -n 19 "+x264+" "+x264_sar+" "+x264crf+u" "+x264_addline+u"  --threads "+x264_thread+" "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" "+streampath+" "+x264streamsize
    encexe=u"nice -n 19 " +encexe
    recdblist.printutf8(encexe)
    txt=""
    try:
        txt=unicode(commands.getoutput(encexe.encode('utf-8')),'utf-8')
    except:
        ""
    os.system("rm "+streampath)
    recdblist.addCommandLog(pin, u"Mencoder", encexe, txt)

def encode_ffmpeg(pin,pout,size,is24fps,quality,crf):
    """
    
    """
    ffmpeg=configreader.getpath("ffmpeg")
    x264=configreader.getpath("x264")
    fps=u"-r 29.970030 "
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="2500"
    x264_thread="auto"
    try:
        xtt=configreader.getenv("x264_thread")
        xtt=int(xtt)
        if xtt>0:
            x264_thread=str(xtt)
    except:
        x264_thread="auto"
    x264_addline=configreader.getenv("x264_addline")
    if size == "HD":
        s = "-s 1280x720 "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        s = "-s 854x480 "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        s = "-s 1920x1080 "
        x264streamsize=u"1920x1080"
        x264_bitrate="5000"
    elif size == "SD":
        s = "-s 720x480 "
        x264streamsize=u"720x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        s = "-s 320x240 "
        x264streamsize=u"320x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        s = "-s 854x480 "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    else:
        s = "-s 1280x720 "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    txt=""
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -y -i \""+pin+"\" -vsync 400 -vcodec rawvideo -pix_fmt yuv420p "+s+fps+"-deinterlace -an -f rawvideo - |"
    exe=exe+u" nice -n 19 "+x264+" "+x264crf+u" "+x264_addline+u" --threads "+x264_thread+" "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" - "+x264streamsize
    exe = "nice -n 19 " + exe
    txt=""
    recdblist.printutf8(exe)
    try:
        txt=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    except:
        ""
    recdblist.addCommandLog(pin, u"FFmpeg動画エンコード", exe, txt)
def encode_ffmpeg_sar(pin,pout,size,is24fps,quality,crf):
    """

    """
    ffmpeg=configreader.getpath("ffmpeg")
    x264=configreader.getpath("x264")
    fps=u"-r 29.970030 "
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="2500"
    x264_thread="auto"
    tsar=getMoviePAR(pin)
    x264_sar="--sar "+str(tsar[0])+":"+str(tsar[1])
    try:
        xtt=configreader.getenv("x264_thread")
        xtt=int(xtt)
        if xtt>0:
            x264_thread=str(xtt)
    except:
        x264_thread="auto"
    x264_addline=configreader.getenv("x264_addline")
    if size == "HD":
        tsize=get_par_size(pin,720)
        s = "-s "+str(tsize[0])+"x720 "
        x264streamsize=str(tsize[0])+u"x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        tsize=get_par_size(pin,480)
        s = "-s "+str(tsize[0])+"x480 "
        x264streamsize=str(tsize[0])+u"x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        tsize=get_par_size(pin,1080)
        s = "-s "+str(tsize[0])+"x1080 "
        x264streamsize=str(tsize[0])+u"x1080"
        x264_bitrate="5000"
    elif size == "SD":
        tsize=get_par_size(pin,480)
        s = "-s "+str(tsize[0])+"x480 "
        x264streamsize=str(tsize[0])+u"x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        tsize=get_par_size(pin,240)
        s = "-s "+str(tsize[0])+"x240 "
        x264streamsize=str(tsize[0])+u"x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        tsize=get_par_size(pin,480)
        s = "-s "+str(tsize[0])+"x480 "
        x264streamsize=str(tsize[0])+u"x480"
        x264_bitrate="1500"
    else:
        tsize=get_par_size(pin,720)
        s = "-s "+str(tsize[0])+"x720 "
        x264streamsize=str(tsize[0])+u"x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    txt=""
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -y -i \""+pin+"\" -vsync 400 -vcodec rawvideo -pix_fmt yuv420p "+s+fps+"-deinterlace -an -f rawvideo - |"
    exe=exe+u" nice -n 19 "+x264+" "+x264_sar+" "+x264crf+u" "+x264_addline+u" --threads "+x264_thread+" "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" - "+x264streamsize
    exe = "nice -n 19 " + exe
    txt=""
    recdblist.printutf8(exe)
    try:
        txt=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    except:
        ""
    recdblist.addCommandLog(pin, u"FFmpeg動画エンコード", exe, txt)
def encode_ffmpeg_kai(pin,pout,size,is24fps,quality,crf):
    """

    """
    ffmpeg=configreader.getpath("ffmpeg")
    x264=configreader.getpath("x264")
    fps=u"-r 29.970030 "
    x264fps="--fps 30000/1001"
    x264streamsize=""
    x264preset=""
    x264tune=""
    x264_bitrate="2500"
    x264_thread="auto"
    try:
        xtt=configreader.getenv("x264_thread")
        xtt=int(xtt)
        if xtt>0:
            x264_thread=str(xtt)
    except:
        x264_thread="auto"
    x264_addline=configreader.getenv("x264_addline")
    if size == "HD":
        padx=get16_9ffmpeg_s(pin,1280,720)
        s = "-s "+str(1280-2*padx)+"x720 "
        if padx>0:
            s=s+"-padleft "+str(padx)+" -padright "+str(padx)+" "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    elif size == "WVGA":
        padx=get16_9ffmpeg_s(pin,854,480)
        s = "-s "+str(854-2*padx)+"x480 "
        if padx>0:
            s=s+"-padleft "+str(padx)+" -padright "+str(padx)+" "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    elif size == "FullHD":
        padx=get16_9ffmpeg_s(pin,1920,1080)
        s = "-s "+str(1920-2*padx)+"x1080 "
        if padx>0:
            s=s+"-padleft "+str(padx)+" -padright "+str(padx)+" "
        x264streamsize=u"1920x1080"
        x264_bitrate="5000"
    elif size == "SD":
        s = "-s 720x480 "
        x264streamsize=u"720x480"
        x264_bitrate="1250"
    elif size == "QVGA_BASE":
        s = "-s 320x240 "
        x264streamsize=u"320x240"
        x264_bitrate="300"
    elif size == "WVGA_BASE":
        s = "-s 854x480 "
        x264streamsize=u"854x480"
        x264_bitrate="1500"
    else:
        padx=get16_9ffmpeg_s(pin,1280,720)
        s = "-s "+str(1280-2*padx)+"x720 "
        if padx>0:
            s=s+"-padleft "+str(padx)+" -padright "+str(padx)+" "
        x264streamsize=u"1280x720"
        x264_bitrate="2500"
    if quality==1:
        x264preset=u"--preset ultrafast"
    elif quality==2:
        x264preset=u"--preset veryfast"
    elif quality==3:
        x264preset=u"--preset fast"
    elif quality==4:
        x264preset=u"--preset medium"
    elif quality==5:
        x264preset=u"--preset slow"
    elif quality==6:
        x264preset=u"--preset slower"
    if size == "WVGA_BASE" or size == "QVGA_BASE":
        x264profile=" --level 32 --profile baseline "
    else:
        x264profile=" --level 41 --profile high "
    x264crf=u"--crf "+str(crf)
    txt=""
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -y -i \""+pin+"\" -vsync 400 -vcodec rawvideo -pix_fmt yuv420p "+s+fps+"-deinterlace -an -f rawvideo - |"
    exe=exe+u" nice -n 19 "+x264+" "+x264crf+u" "+x264_addline+u" --threads "+x264_thread+" "+x264profile+x264preset+" "+x264tune+" "+x264fps+" -o \""+pout+"\" - "+x264streamsize
    exe = "nice -n 19 " + exe
    txt=""
    recdblist.printutf8(exe)
    try:
        txt=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    except:
        ""
    recdblist.addCommandLog(pin, u"FFmpeg動画エンコード", exe, txt)
def getMovieSize(pin):
    ffmpeg=configreader.getpath("ffmpeg")
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -i \""+pin+"\" 2>&1"
    txts=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    rT=re.compile(u".*Stream.*#.*:.*\D+([\d]+x[\d]+)\D+PAR\D+(\d+:\d+)\D+.*\Z")
    sizeMaxX=0
    sizeMaxY=0
    txtls=txts.split("\n")
    for t in txtls:
        rM=rT.match(t)
        if rM:
            sizetxt=rM.group(1)
            partxt=rM.group(2)
            tX=int(sizetxt.split("x")[0])
            tY=int(sizetxt.split("x")[1])
            tEX=int(partxt.split(":")[0])
            tEY=int(partxt.split(":")[1])
            if tX==1920 and tY==1080:
                tEX=1
                tEY=1
            tX2=tX*tEX*10/tEY
            if tX2>10*int(tX2/10):
                tX2=tX2/10+1
            else:
                tX2=tX2/10
            if sizeMaxX<tX2:
                sizeMaxX=tX2
                sizeMaxY=tY
    return [sizeMaxX,sizeMaxY]
def getMovieBaseSize(pin):
    ffmpeg=configreader.getpath("ffmpeg")
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -i \""+pin+"\" 2>&1"
    txts=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    rT=re.compile(u".*Stream.*#.*:.*\D+([\d]+x[\d]+)\D+PAR\D+(\d+:\d+)\D+.*\Z")
    sizeMaxX=0
    sizeMaxY=0
    txtls=txts.split("\n")
    for t in txtls:
        rM=rT.match(t)
        if rM:
            sizetxt=rM.group(1)
            partxt=rM.group(2)
            tX=int(sizetxt.split("x")[0])
            tY=int(sizetxt.split("x")[1])
            tEX=int(partxt.split(":")[0])
            tEY=int(partxt.split(":")[1])
            if sizeMaxX<tX:
                sizeMaxX=tX
                sizeMaxY=tY
    return [sizeMaxX,sizeMaxY]
def getMoviePAR(pin):
    ffmpeg=configreader.getpath("ffmpeg")
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -i \""+pin+"\" 2>&1"
    txts=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    rT=re.compile(u".*Stream.*#.*:.*\D+([\d]+x[\d]+)\D+PAR\D+(\d+:\d+)\D+.*\Z")
    #rT=re.compile(u".*Stream.*#.*:.*\D+([\d]+x[\d]+)\D+.*DAR\D+(\d+:\d+)\D+.*\Z")
    sizeMaxX=0
    parx=0
    pary=0
    txtls=txts.split("\n")
    for t in txtls:
        rM=rT.match(t)
        if rM:
            sizetxt=rM.group(1)
            dartxt=rM.group(2)
            tX=int(sizetxt.split("x")[0])
            tY=int(sizetxt.split("x")[1])
            tEX=int(dartxt.split(":")[0])
            tEY=int(dartxt.split(":")[1])
            if sizeMaxX<tX:
                sizeMaxX=tX
                if tX==1920 and tY==1080:
                    parx=1
                    pary=1
                else:
                    parx=tEX
                    pary=tEY
    return [parx,pary]
def getMovieDAR(pin):
    ffmpeg=configreader.getpath("ffmpeg")
    os.environ['LANG']="ja_JP.UTF-8"
    exe=ffmpeg+u" -i \""+pin+"\" 2>&1"
    txts=unicode(commands.getoutput(exe.encode('utf-8')),'utf-8')
    rT=re.compile(u".*Stream.*#.*:.*\D+([\d]+x[\d]+)\D+.*DAR\D+(\d+:\d+)\D+.*\Z")
    sizeMaxX=0
    darx=0
    dary=0
    txtls=txts.split("\n")
    for t in txtls:
        rM=rT.match(t)
        if rM:
            sizetxt=rM.group(1)
            dartxt=rM.group(2)
            tX=int(sizetxt.split("x")[0])
            tY=int(sizetxt.split("x")[1])
            tEX=int(dartxt.split(":")[0])
            tEY=int(dartxt.split(":")[1])
            if sizeMaxX<tX:
                sizeMaxX=tX
                if tX==1920 and tY==1080:
                    darx=16
                    dary=9
                else:
                    darx=tEX
                    dary=tEY
    return [darx,dary]
def get16_9ffmpeg_s(pin,x,y):
    try:
        tDAR=getMovieDAR(pin)
        if (tDAR[0]==16 and tDAR[1]==9):
            return 0
        elif tDAR==[0,0]:
            return 0
        else:
            tSize=getMovieSize(pin)
            tn=x-tSize[1]*x/tSize[0]
            tn=tn/4
            tn=tn*2#偶数にするための処理
            return tn
    except:
        return 0
def get_par_size(pin,y):
    tSize=getMovieBaseSize(pin)
    tX=tSize[0]*10*y/tSize[1]
    tY=y
    if tX>int(tX/10)*10:
        tX=tX/10+1
    else:
        tX=tX/10
    return [tX,tY]